##########################################################################
# TPM 2.0 Sample Provisioning Script -- for development systems 
# Copyright Intel Corporation 2015
# Last update: Jan 12, 2017
##########################################################################
##########################################################################
# Usage:                                                                 #
#     TakeOwnership.nsh   <alg>   <fileNamePrefix>  [-NE]                #
#  Where:                                                                #
#      <alg> is  a supported hash algorithm                              #
#         Such as SHA1, SHA256, SHA384, SHA512, SM3                      #
#         <alg> will be substituted for %1 in Tpm2ProvTool command lines #
#      <fileNamePrefix> is the file name prefix you used to create the   #
#         def files - typically a project name or platform name          #
#        (e.g., MyFirst; Example; Purley)                                #
#         <fileNamePrefix> will be substituted for %2 in command lines   #
#    For example %2PhSecretOR%1.iDef --> ExamplePhSecretORSha256.pDef    #
#                %2PhSecretOR%1.iDef --> MyFirstPhSecretORShaSha384.pDef #
#     -NE is optional and instructs the script to set OwnerAuth value    #
#        if not specified, Owner Auth will be left empty                 #
##########################################################################

echo -OFF 
# Copyrights:
# You may copy, distribute, and make derivatives of this script under the 
# following provisions:
#  You must not remove or modify the Intel copyright notice nor these requirements
#  The script must only be used to provision a TPM for use with Intel Technologies
#    For any other use you must get written permission from Intel corporation
 
##########################################################################
#This script will enable storage hierarchy and optionally set the OwnerAuth value
# It requires PlatformAuth is set to EMPTY - so it calls ResetPlatformAuth.nsh
##########################################################################
#Check that Alg parameter is present
if ZZ%1  == ZZ   then
	echo Algorithm parameter missing
	echo Syntax: %0 <alg> <PlatformName>
	echo   Examples: 
	echo     %0 SHA256 Example 
	echo     %0 SHA384 MyFirst
	echo     %0 SHA512 Grantley
	goto EOF
endif
# Check if alg parameter supported
if NOT EXIST Policy%1.sDef then  
	echo Algorithm not supported
	goto EOF
endif
# Check if platform parameter supported
if NOT EXIST %2PhSecretOR%1.iDef then  
	echo Platform Name not valid
	goto EOF
endif

:STARTLOG
echo %0 %1 %2 %3 > SetPlatformAuth.log
###################################################################

# Make sure Storage hierarchy is enabled
# assumes PlatfromAuth is EMPTY
Tpm2ProvTool StartSession EmptyAuthPwSession.sDef 1 >> Tpm2PoProv.log
echo **** Enabling Storage Hierarchy
echo **** Enabling Storage Hierarchy >> Tpm2PoProv.log
Tpm2ProvTool HierarchyControl 1 0x4000000C 0x40000001 1 >> Tpm2Ownership.log

# Now change the OwnerAuth value if Param 3 is -NE
if p%3 == p then
    goto DONE
endif
if NOT p%3 == "p-NE" then
    echo Parameter 3 not valid
endif
Tpm2ProvTool HierarchyChangeAuth SH %2OwnerAuth.auth 1 >> Tpm2Ownership.log
if %lasterror%  then
	echo Did not set OwnerAuth 
	goto ERROR		
endif

:DONE
echo  ***************************************************
echo  ******* Provisioning Completed Successfully *******
echo  ***************************************************

goto EOF

:ERROR
echo  ***************************************************
echo  *************** Provisioning FAILED ***************
echo  ***************************************************
Tpm2ProvTool FlushSession 0 >> Tpm2Ownership.log

goto EOF

:EOF
